#!/bin/bash

CC=gcc
W="-Wall -Wextra -Wshadow -Wno-unused-parameter"
D="-DEXTENDED_HEIGHT"
G="-g3"
O="-O3"
I="-I/opt/libpng/include"
L="-L/opt/libpng/lib"
B="krunpack"

rm $B
rm *.o

fcc() {
  echo "${CC}" $*
  "${CC}" $*
}

fcc -c ${I} ${G} ${O} ${W} ${D} -o citconf.o citconf.c && \
fcc -c ${I} ${G} ${O} ${W} ${D} -o krunpack.o krunpack.c && \
fcc -c ${I} ${G} ${O} ${W} ${D} -o cit_io.o cit_io.c && \
fcc -c ${I} ${G} ${O} ${W} ${D} -o world.o world.c && \
fcc -c ${I} ${G} ${O} ${W} ${D} -o roomdata.o roomdata.c && \
fcc -c ${I} ${G} ${O} ${W} ${D} -o parse.o parse.c && \
fcc -c ${I} ${G} ${O} ${W} ${D} -o vram.o vram.c && \
fcc -c ${I} ${G} ${O} ${W} ${D} -o tiledata.o tiledata.c && \
fcc -c ${I} ${G} ${O} ${W} ${D} -o tilegfx.o tilegfx.c && \
fcc -c ${I} ${G} ${O} ${W} ${D} -o citpng.o citpng.c && \
fcc -c ${I} ${G} ${O} ${W} ${D} -o triangle.o triangle.c && \
fcc -c ${I} ${G} ${O} ${W} ${D} -o raster.o raster.c && \
fcc ${L} -o ${B} \
  citconf.o \
  krunpack.o \
  cit_io.o \
  world.o \
  roomdata.o \
  parse.o \
  vram.o \
  tiledata.o \
  tilegfx.o \
  citpng.o \
  triangle.o \
  raster.o \
  -lpng







 
