#include "citpng.h"
//#include "crunpack.h"
#include "png.h"
#include "cit_io.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

static png_voidp cit_png_malloc(png_structp ps, size_t size);
static void cit_png_free(png_structp ps, png_voidp p);

static void png_write_cleanup(FILE *f,
                              png_structp *png,
                              cit_png_membuf_t *mb,
                              png_infop *info_ptr);
static void cb_png_flush_to_ram (png_structp png);
static void cb_png_write_to_ram (png_structp png, png_bytep chunk, png_size_t chunklen);

#define PNG_WRITE_BUF_DELTA 1000000

static void cb_png_write_to_ram (png_structp png, png_bytep chunk, png_size_t chunklen) {

  cit_png_membuf_t *mb;
  size_t new_size;
  
//~ DD_PRINTF("PNG chunklen = %zu\n", chunklen);

  mb = (cit_png_membuf_t *) png_get_io_ptr (png);
  if (NULL == mb) { return; }
  if ( ! CAN_ADD_SZT (mb->pos, chunklen) ) { return; }
  if ((mb->pos + chunklen) > mb->alloc) {
    // realloc
    if ( ! CAN_ADD_SZT (mb->alloc, PNG_WRITE_BUF_DELTA) ) { return; }
    new_size = mb->alloc + PNG_WRITE_BUF_DELTA;
    mb->buf = realloc(mb->buf, new_size);
    mb->alloc = new_size;
  }
  memcpy(mb->buf + mb->pos, chunk, chunklen);
  mb->pos += chunklen;
}

static png_voidp cit_png_malloc(png_structp ps, size_t size) {
  return malloc(size);
}

static void cb_png_flush_to_ram (png_structp png) {

}

static void cit_png_free(png_structp ps, png_voidp p) {
  free(p);
}

citerr_t cit_save_png (u8_t *bitmap8,
                       s32_t width, s32_t height,
                       char *path,
                       u8_t source_type, // CIT_PNG_SRC_TYPE_*
                       u8_t allow_overwrite,
                       size_t *filesize_out,
                       s32_t bitmap_stride_bytes) {
                          
  citerr_t e;
  //u8_t *bitmap8;
  cit_png_membuf_t membuf;
  s32_t y;
  u8_t bypp;
  
  FILE *fp;
  png_structp png_ptr;
  png_infop info_ptr;
  
  fp = NULL;
  png_ptr = NULL;
  info_ptr = NULL;
  
  memset(&membuf, 0, sizeof(cit_png_membuf_t));
  
  if (width > CIT_PNG_MAX_SAVE_WIDTH) {
    printf("ERROR: PNG width exceeds maximum allowed for saving (%u pixels, max. %u).\n",
              width, CIT_PNG_MAX_SAVE_WIDTH);
    return CE_PNG_BAD_WIDTH;
  }
  if (height > CIT_PNG_MAX_SAVE_HEIGHT) {
    printf("ERROR: PNG height exceeds maximum allowed for saving (%u pixels, max. %u).\n",
              height, CIT_PNG_MAX_SAVE_HEIGHT);
    return CE_PNG_BAD_HEIGHT;
  }
  
  fp = cit_fopen(path, "wb");
  if (fp == NULL) { return CE_PNG_SAVE_FOPEN; }
                                    
  png_ptr = png_create_write_struct_2(PNG_LIBPNG_VER_STRING,
                                      (png_voidp) NULL,
                                      (png_voidp) NULL,
                                      (png_error_ptr) NULL,
                                      (png_voidp) NULL,
                                      cit_png_malloc,
                                      cit_png_free);
                                    
  if (NULL == png_ptr) {
    png_write_cleanup(fp, &png_ptr, &membuf, &info_ptr);
    return CE_PNG_SAVE_CREATE_STRUCT;
  }

  info_ptr = png_create_info_struct(png_ptr);
  if (NULL == info_ptr) {
    png_write_cleanup(fp, &png_ptr, &membuf, &info_ptr);
    return CE_PNG_SAVE_CREATE_INFO_STRUCT;
  }
  
  //~ if (setjmp(mainprog_ptr->jmpbuf)) {
    //~ png_destroy_write_struct(&png_ptr, &info_ptr);
    //~ return 2;
  //~ }
  
  if (setjmp (png_jmpbuf (png_ptr))) {
    printf("ERROR: setjmp() while saving PNG file.\n");
    //~ png_load_fail(1, bitmap, &aopter, &png, pnginfo, png_endinfo);
    png_write_cleanup(fp, &png_ptr, &membuf, &info_ptr);
    return CE_PNG_SETJMP;
	}
  
  //~ png_init_io(png_ptr, mainprog_ptr->outfile);
  
  bypp = (source_type == CIT_PNG_SRC_TYPE_RGB24) ? 3 : 4;
  
  png_set_compression_level(png_ptr, PNG_Z_DEFAULT_COMPRESSION);
  png_set_write_fn(png_ptr, &membuf, cb_png_write_to_ram, cb_png_flush_to_ram);
  png_set_IHDR (png_ptr,
                info_ptr,
                width,
                height,
                8, //mainprog_ptr->sample_depth,
                (bypp == 4) ? PNG_COLOR_TYPE_RGB_ALPHA : PNG_COLOR_TYPE_RGB,
                PNG_INTERLACE_NONE,
                PNG_COMPRESSION_TYPE_DEFAULT,
                PNG_FILTER_TYPE_DEFAULT);
  png_write_info(png_ptr, info_ptr);
  //~ png_set_packing(png_ptr);
  
  //bitmap8 = (u8_t *) bitmap;
  
  for (y=0; y < height; y++) {
    png_write_row (png_ptr, bitmap8 + (bitmap_stride_bytes * y));
  }
  
  png_write_end(png_ptr, NULL);
  
  e = cit_write_file(path, allow_overwrite, membuf.buf, membuf.pos, 0); // 0 = make path
  
  if (CE_OK == e) { *filesize_out = membuf.pos; }
  
  png_write_cleanup(fp, &png_ptr, &membuf, &info_ptr);
  
  return e;
  
}

static void png_write_cleanup(FILE *f,
                              png_structp *png,
                              cit_png_membuf_t *mb,
                              png_infop *info_ptr) {

  if (NULL != f)        { fclose(f); }
  if (NULL != info_ptr) { png_destroy_info_struct(*png, info_ptr); }
  if (NULL != png)      { png_destroy_write_struct(png, NULL); }
  if (NULL != mb->buf)  { free(mb->buf); }

  memset(mb, 0, sizeof(cit_png_membuf_t));
}

