#include "raster.h"
#include "krunpack.h"

#include <stdio.h>
#include <stdlib.h>

#define RASTER_SPANS_ALLOC_DELTA 10

#define MAX_RASTER_SPANS 10000


citerr_t get_next_span (u32_t *num_spans_inout,
                        u32_t *alloced_inout,
                        raster_span_t **spans_inout,
                        raster_span_t **next_span_out) {
  u32_t new_size;
  if (*alloced_inout > MAX_RASTER_SPANS) {
    printf("ERROR: insane alloced_inout: %u\n", *alloced_inout);
    return CE_BUG;
  }
  if ((*num_spans_inout) >= (*alloced_inout)) {
    new_size = RASTER_SPANS_ALLOC_DELTA + (*num_spans_inout);
    if (new_size >= MAX_RASTER_SPANS) {
      printf("ERROR: maximum spans exceeded (%u)\n", MAX_RASTER_SPANS);
      free(*spans_inout);
      *spans_inout = NULL;
      *alloced_inout = 0;
      *num_spans_inout = 0;
      *next_span_out = NULL;
      return CE_RASTER_TOO_MANY_SPANS;
    }
    (*alloced_inout) = new_size;
//~ printf("get_next_span: before realloc(): num_spans = %u, alloced = %u, new_size = %u, spans_inout = %p, *spans_inout = %p\n",
        //~ *num_spans_inout, *alloced_inout, new_size, spans_inout, *spans_inout); fflush(stdout);
    *spans_inout = realloc(*spans_inout, sizeof(raster_span_t) * new_size);
  }
//~ printf("nsio: %u -> ", *num_spans_inout);
  (*num_spans_inout)++;
//~ printf("%u\n", *num_spans_inout);
  *next_span_out = (*spans_inout) + (*num_spans_inout) - 1;
  return CE_OK;
}


