
#include "roomdata.h"

#include <stdio.h>

void room_data_init (room_data_t *roomdata, u8_t *buf, u16_t buflen) {
  roomdata->buf = buf;
  roomdata->len = buflen;
  roomdata->pos = 0;
}

citerr_t room_data_extread (room_data_t *roomdata, u16_t pos, u8_t *out) {
  if ( CE_OK != room_data_ext_inbounds (roomdata, pos) ) {
    printf("ERROR: room_data_extread(): overflow (pos %x, len %x)\n",
           pos, roomdata->len);
    return CE_ROOM_DATA_EXTREAD_OVERFLOW;
  }
  *out = roomdata->buf[pos];
  return CE_OK;
}

citerr_t room_data_read (room_data_t *roomdata, u8_t *out) {
  citerr_t e;
  e = room_data_extread (roomdata, roomdata->pos, out);
  if (CE_OK != e) { return e; }
//printf("next_room_byte: [%x] = 0x%x\n", this.pos, c);
  roomdata->pos++;
  return CE_OK;
}

citerr_t room_data_ext_inbounds (room_data_t *roomdata, u16_t pos) {
  return ((pos < roomdata->len) /*&& (pos >= 0)*/) ? CE_OK : CE_ROOM_DATA_TEST;
}

citerr_t room_data_inbounds (room_data_t *roomdata) {
  return room_data_ext_inbounds(roomdata, roomdata->pos);
}

citerr_t room_data_advance (room_data_t *roomdata, u8_t distance) {
  u32_t i;
  i = roomdata->pos;
  i += distance;
  if (i >= roomdata->len) {
    printf("ERROR: room_data_advance(%u): overflow; ptr now %u\n", distance, i);
    return CE_ROOM_DATA_ADVANCE_OVERFLOW;
  }
  roomdata->pos += distance;
  return CE_OK;
}

void room_data_reset (room_data_t *roomdata) {
  roomdata->pos = 0;
}

citerr_t room_data_rewind (room_data_t *roomdata) {
  if (roomdata->pos == 0) {
    printf ("ERROR: room_data_rewind(): cannot rewind past 0\n");
    return CE_ROOM_DATA_REWIND_0;
  }
  roomdata->pos--;
  return CE_OK;
}

void room_id_init (room_id_t *rid) {
  rid->original = -1;
  rid->redirected = -1;
}

s16_t room_id_fetch (room_id_t *rid) {
  return (rid->redirected == -1) ? rid->original : rid->redirected;
}
