#ifndef TILEDATA_H
#define TILEDATA_H

#include "krunpack.h"

#define NUM_TILESLOTS                  12

#define TILEDATA_START                 0x955
#define TILEDATA_LEN                   0xa4b
#define T_400_LEN                      0xc8
#define T_500_LEN                      0xd4
#define T_600_LEN                      0x150
#define TILE_DATASRC_TILEDATA          0
#define TILE_DATASRC_400               1
#define TILE_DATASRC_600               2
#define T_400_PTR_START                0x400
#define T_600_PTR_START                0x600

// significant tile IDs
#define TID_WATER_SURFACE              0x0c
#define TID_SWITCH                     0x0f
#define TID_ITEM_PAD                   6
#define TID_LOW_FLASK                  7
#define TID_HIGH_FLASK                 8
#define TID_FIRST_DOOR                 0x40
#define TID_PILLAR_TOP                 0x20
#define TID_BLANK                      0x1a
#define TID_ROPE_BRACKET               0x25
#define TID_ZIGZAG                     0x26
#define TID_LAST_CRYSTAL               4
#define TID_PARABOLIC_ANTENNA          16
#define TID_BRICK_YELLOW_RED_MAGENTA   88
#define TID_MAX                        117

typedef struct tile_data {
  
  u8_t t400[T_400_LEN];
  u8_t t600[T_600_LEN]; // not yet used
  u8_t t955[TILEDATA_LEN];

  u8_t ptr_L;
  u8_t ptr_H;
  
  //u16_t delta;
  
} tile_data_t;

typedef struct tile_slot {
  // FIXME: add a 'src' parameter so we know
  // whether ptr is meant to point to 400, 500 or 600
  u16_t ptr;
  u8_t height;
  u8_t vram_target;
  u8_t stripe;
  u8_t offset_500buf;
  u8_t use_branch_B;
  u8_t anim_type;
  u8_t anim_speed;
  u8_t anim1;
  u8_t unk2;
} tile_slot_t;

void tile_data_reset (tile_data_t *tiledata);
void tile_data_init (tile_data_t *tiledata,
                     u8_t t955[TILEDATA_LEN],
                     u8_t t600[T_600_LEN]);
citerr_t tile_data_offread (tile_data_t *tiledata, u8_t off, u8_t *out);
citerr_t tile_data_read (tile_data_t *tiledata, u8_t *out);
citerr_t tile_data_extread (tile_data_t *tiledata, u16_t ptr, u8_t *out);
citerr_t tile_data_write (tile_data_t *tiledata, u16_t ptr, u8_t c);
u8_t tile_data_getextsrc (u16_t ptr);
void tile_data_wipe400 (tile_data_t *tiledata);
u16_t tile_data_getptr (tile_data_t *tiledata);
citerr_t tile_data_getsrc (tile_data_t *tiledata);
void tile_data_setptr (tile_data_t *tiledata, u16_t ptr);
citerr_t tile_data_advance (tile_data_t *tiledata, u8_t num_bytes, u8_t *carry_out);
void tile_slot_init (tile_slot_t *slot);
citerr_t tile_data_regress (tile_data_t *tiledata, u8_t *carry_out);

#endif
