#ifndef TILEGFX_H
#define TILEGFX_H

#include "krunpack.h"
#include "tiledata.h"
#include "world.h"
#include "vram.h"

citerr_t unpack_tile_gfx (tile_data_t *tiledata,
                          u8_t tile_id,
                          u8_t t_500_inout[T_500_LEN],
                          u8_t t_xyzzy_out[4],
                          u8_t *next_tile_slot_inout,
                          // FIXME: just pass in a single 16-bit number for these two, i.e. 0x400 usually:
                          u8_t t400_ptr_L_initial, // don't know if these are needed; they're usually 0
                          u8_t t400_ptr_H_initial, // and 4, if initialised, but the NYI animation code seems to call it w/o initialisation at 39ad
                          u8_t tile_500buf_pos_1_initial,
                          u8_t tile_500buf_pos_2_initial,
                          s8_t *tile_width_maybe_out, // s8? u8? tile width? returned value only needed by flood tile fill, discarded elsewhere
                          tile_slot_t tileslots_inout[NUM_TILESLOTS],
                          u8_t initialise,
                          u8_t pixel_base_pairs[WORLD_NUM_PXPAIRS],
                          u8_t animation_speeds[WORLD_NUM_ANIMSPEEDS],
                          u8_t *carry_out);
                          
citerr_t tile_plot_a_slot_0 (tile_data_t *tiledata,
                             tile_slot_t *ts0,
                             u8_t t_500[T_500_LEN],
                             u8_t plot_mode,
                             u8_t x,
                             u8_t y,          // in A register
                             vram_t *vram);
                             
citerr_t tile_plot_specify_tile_slot (tile_data_t *tiledata,
                                      tile_slot_t *ts,
                                      u8_t t_500[T_500_LEN],
                                      u8_t plot_mode,
                                      u8_t xcoord,
                                      u8_t ycoord,                  // in A register
                                      u8_t force_branch_b,          // simulates direct jump to branch B in asm
                                      u8_t branch_B_entry_point_h,  // FIXME: remove this and just pass entry_point_h_overridden_500buf_offset or NULL/FALSE/-1
                                      u8_t branch_B_entry_point_h_overridden_500buf_offset, // FIXME: just always pass in separate 500buf offset
                                      vram_t *vram);

#endif
