#ifndef VRAM_H
#define VRAM_H

#include "krunpack.h"

#define VRAM_START_HIGH_BYTE           0x44
#define VRAM_GFX_WINDOW_START          0x4900
#define VRAM_START_HARD_LIMIT          0x46f0 //0x4700 //0x4820
#define VRAM_LENGTH                    0x3700
#define FRAMEBUF_NUM_PIXELS            (VRAM_LENGTH * 2 * 2) // *2 => two pixels per MODE 2 byte *2 => double-width pixels

#define FRAMEBUF_WIDTH      160
#define FRAMEBUF_MAX_HEIGHT 192
#define FRAMEBUF_MIN_HEIGHT 176

#ifdef EXTENDED_HEIGHT
#define FRAMEBUF_HEIGHT FRAMEBUF_MAX_HEIGHT
#else
#define FRAMEBUF_HEIGHT FRAMEBUF_MIN_HEIGHT
#endif

#define BLIT_STA 0
#define BLIT_EOR 1
#define BLIT_AND 2
#define BLIT_ORA 3

typedef struct vram {

  s32_t linlen;
  u8_t linvis[FRAMEBUF_HEIGHT * FRAMEBUF_WIDTH * 4]; // linear framebuffer, visible, 32 bpp RGBA
  u8_t lincol[FRAMEBUF_HEIGHT * FRAMEBUF_WIDTH * 4]; // linear framebuffer, collision, 32 bpp RGBA
  
} vram_t;

citerr_t vram_read    (vram_t *vram, u16_t pos, u8_t *out);
citerr_t vram_write   (vram_t *vram, u16_t pos, u8_t byte);
void     vram_init    (vram_t *vram, u8_t height);
citerr_t vram_op      (vram_t *vram, u8_t blit_mode, u8_t value, u16_t addr);
citerr_t vram_copy2px (vram_t *vram, u16_t dstaddr, u16_t srcaddr);
citerr_t vram_linplot (vram_t *vram,
                       s16_t x,
                       s16_t y,
                       u8_t r,
                       u8_t g,
                       u8_t b,
                       u8_t c);

#endif
