#!/bin/bash

# output binary
BIN="quadbike"

# library paths
I="-I/opt/libsndfile/include"
LP="-L/opt/libsndfile/lib"

# set paths to these if nonstandard
CLANG="clang"
GCC="gcc"
STRIP="strip"

W="-Wall -Wextra -Wshadow"
L="-lm -lsndfile -lz"

DX=""
OX="-march=native"
GX=""

O0="-O0 $OX"
O3="-O3 $OX"
G0="-g0 $GX"
G3="-g3 $GX"
SIMD_NONE=""
SIMD_SSE="-DQB_VECTORS_GCC_CLANG -DQB_VECSIZE=4"
SIMD_AVX2="-DQB_VECTORS_GCC_CLANG -DQB_VECSIZE=8"
SIMD_AVX512="-DQB_VECTORS_GCC_CLANG -DQB_VECSIZE=16"
D_LINUX="-DQB_LINUX $DX"
D_MACOS="-DQB_MACOS $DX"

#######

rm -f "${BIN}"
rm -f *.o
rm -f taps/*.o


# files go here

F="quadbike pll util qbio goertzel csw fir process audio"
F="$F tapespeed source atom errcorr"
F="$F sync_pll sync_goertzel sync_walk span sync"
F="$F inspect polarity tibet vector fir_vec2"

F="$F taps/bp_2k4_22k taps/bp_2k4_44k taps/bp_2k4_48k"
F="$F taps/bp_0k4_3k2_22k taps/bp_0k4_3k2_44k taps/bp_0k4_3k2_48k"



func_cc() {
  func_cc2 -c -o $1.o $1.c
}

func_ld() {
  func_ld2 -o "${BIN}" $*
}

func_cc2() {
  echo ${CC} ${D} ${I} ${A} $*
  "${CC}" ${D} ${I} ${A} $*
}

func_ld2() {
  echo ${CC} $* ${L} ${LP}
  "${CC}" $* ${L} ${LP}
}

func_usage() {
  echo ''
  echo Usage:
  echo '  build.sh <linux|macos> <gcc|clang> <debug|release> <none|sse|avx2|avx512>'
  echo ''
  echo 'e.g.:'
  echo '  build.sh linux gcc release avx2'
  echo ''
}

if [ -z "$4" ] ; then func_usage $0 ; exit 1 ; fi

if [ "$1" != linux ] && [ "$1" != macos ] ; then
  echo Unknown system type: $1
  exit 2
fi
if [ "$2" != gcc ] && [ "$2" != clang ] ; then
  echo Unknown compiler: $2
  exit 3
fi
if [ "$3" != debug ] && [ "$3" != release ] ; then
  echo Unknown target: $3
  exit 4
fi
if    [ "$4" != none ] && [ "$4" != sse ] \
   && [ "$4" != avx2 ] && [ "$4" != avx512  ] ; then
  echo Unknown SIMD option: $4
  exit 5
fi

D=""
if [ "$1" == linux ]   ; then D="$D_LINUX" ; fi
if [ "$1" == macos ]   ; then D="$D_MACOS" ; fi
if [ "$2" == gcc ]     ; then CC="$GCC"    ; fi
if [ "$2" == clang ]   ; then CC="$CLANG"  ; fi
if [ "$3" == debug ]   ; then G="$G3" ; O="$O0" ; fi
if [ "$3" == release ] ; then G="$G0" ; O="$O3" ; STRIPCMD="$STRIP" ; fi
if [ "$4" == none ]    ; then D="$D $SIMD_NONE"   ; fi
if [ "$4" == sse ]     ; then D="$D $SIMD_SSE"    ; fi
if [ "$4" == avx2 ]    ; then D="$D $SIMD_AVX2"   ; fi
if [ "$4" == avx512 ]  ; then D="$D $SIMD_AVX512" ; fi

A="${W} ${O} ${G}"

T=""
for N in $F ; do
  T="${T} ${N}.o"
  if ! func_cc ${N} ; then exit ; fi
done

func_ld ${T}

if [ ! -z "${STRIPCMD}" ] ; then
  echo "${STRIPCMD}" "${BIN}"
  "${STRIPCMD}" "${BIN}"
fi

