/*
 *  Quadbike 2
 *  Copyright (C) 2023 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include "bp_2k4_22k.h"

/*

FIR filter designed with
 http://t-filter.engineerjs.com

sampling frequency: 22050 Hz

* 0 Hz - 2000 Hz
  gain = 0
  desired attenuation = -40 dB
  actual attenuation = -40.40135275464817 dB

* 2200 Hz - 2600 Hz
  gain = 1
  desired ripple = 12 dB
  actual ripple = 8.693903728932693 dB

* 2800 Hz - 11025 Hz
  gain = 0
  desired attenuation = -40 dB
  actual attenuation = -40.40135275464817 dB

*/

const double qb_fir_taps_bp_2k4_22k[QB_FIR_TAPS_BP_2K4_22K] = {
  0.004683957189493989,
  -0.0008380645939412741,
  -0.0024465368138863663,
  -0.004070288035021822,
  -0.004599307997344951,
  -0.0032884229498752653,
  -0.0002537595032300771,
  0.003388276844463242,
  0.0059192853075459495,
  0.0058346672156833704,
  0.00269329030983804,
  -0.002450949595330618,
  -0.0073296640304227716,
  -0.009424320826747632,
  -0.007223576982702899,
  -0.0011580758857399637,
  0.006330574650817544,
  0.011746172967625656,
  0.01215917583985858,
  0.006745224114464248,
  -0.002549434835141224,
  -0.01165253674197544,
  -0.016143105957084604,
  -0.01339074046302998,
  -0.004022477321236806,
  0.008078631215424424,
  0.017374874861464655,
  0.01922061796310257,
  0.012177830315535825,
  -0.0010532128456366876,
  -0.014643590769706763,
  -0.022224580672676266,
  -0.019896396964804865,
  -0.00822366967727226,
  0.007800832142455323,
  0.020909264016607757,
  0.02489352445202832,
  0.01757451023221767,
  0.001971552571961295,
  -0.014949094571627927,
  -0.02542622160750073,
  -0.02451103497488144,
  -0.012431620769356245,
  0.005427721803088237,
  0.02096079591141842,
  0.02707137226719384,
  0.02096079591141842,
  0.005427721803088237,
  -0.012431620769356245,
  -0.02451103497488144,
  -0.02542622160750073,
  -0.014949094571627927,
  0.001971552571961295,
  0.01757451023221767,
  0.02489352445202832,
  0.020909264016607757,
  0.007800832142455323,
  -0.00822366967727226,
  -0.019896396964804865,
  -0.022224580672676266,
  -0.014643590769706763,
  -0.0010532128456366876,
  0.012177830315535825,
  0.01922061796310257,
  0.017374874861464655,
  0.008078631215424424,
  -0.004022477321236806,
  -0.01339074046302998,
  -0.016143105957084604,
  -0.01165253674197544,
  -0.002549434835141224,
  0.006745224114464248,
  0.01215917583985858,
  0.011746172967625656,
  0.006330574650817544,
  -0.0011580758857399637,
  -0.007223576982702899,
  -0.009424320826747632,
  -0.0073296640304227716,
  -0.002450949595330618,
  0.00269329030983804,
  0.0058346672156833704,
  0.0059192853075459495,
  0.003388276844463242,
  -0.0002537595032300771,
  -0.0032884229498752653,
  -0.004599307997344951,
  -0.004070288035021822,
  -0.0024465368138863663,
  -0.0008380645939412741,
  0.004683957189493989
};

