/*
 *  Quadbike 2
 *  Copyright (C) 2023 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_AUDIO2_H
#define QB_AUDIO2_H

#include <stdio.h>

#include "qb_types.h"
#include "sndfile.h"

// for WRITING inspect files:
typedef struct qb_libsndfile_inspect_privdata_s {
  char *path;
  u8_t opened;
  s64_t off;
  s64_t len;
  u8_t allow_overwrite;
  FILE *f;
  // remember, we now open the file in a just-in-time fashion
  // rather than explicitly calling some open() function,
  // and libsndfile will need to know this:
  s32_t rate;
} qb_libsndfile_inspect_privdata_t;

// for DECODING sound files (from a source buffer)
// (this is needed, because that buffer might contain a cycap file instead)
// ^^ this is no longer true, but never mind
typedef struct qb_libsndfile_decode_privdata_s {
  u8_t *buf;
  sf_count_t len;
  sf_count_t pos;
  // this is in 16-bit samples
  // so the actual size of the buffer is twice this:
  s64_t alloc;
} qb_libsndfile_decode_privdata_t;

#endif // QB_AUDIO2_H
