/*
 *  Quadbike 2
 *  Copyright (C) 2023 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_FIR_H
#define QB_FIR_H

#include "quadbike.h"

// these are used for the PLL input mutation:
#include "taps/bp_2k4_22k.h"
#include "taps/bp_2k4_44k.h"
#include "taps/bp_2k4_48k.h"

// these are used for the walk-mode generic input pre-filter (-f option)
#include "taps/bp_0k4_3k2_22k.h"
#include "taps/bp_0k4_3k2_44k.h"
#include "taps/bp_0k4_3k2_48k.h"

// MUST BE SET TO THE LARGEST NUMBER OF TAPS
// OUT OF ALL OF THE FIR FILTERS!
#define QB_FIR_MAX_TAPS     1000 // *** FIXME *** QB_FIR_TAPS_BP_1K2_44K // currently the largest, at 567 taps

typedef struct qb_fir_s {
  double history[QB_FIR_MAX_TAPS]; // ring buffer
  u32_t last_index; // index into ring buffer
  u32_t num_taps; // BANDPASS_xK_NUM_TAPS
  const double *taps; // pointer to appropriate static bandpass_xk_taps[]
  s32_t delay;
} qb_fir_t;

qb_err_t qb_fir_init (qb_fir_t *f, u8_t type, u8_t rate);
u8_t qb_sample_rate_ix_from_rate (s32_t rate);
void qb_fir_in (qb_fir_t *f, float input);
float qb_fir_out (qb_fir_t *f);
u8_t qb_validate_sample_rate_ix (u8_t rate_ix);

#define QB_FIR_TYPE_BP_2K4      1
//#define QB_FIR_TYPE_LP_1K9      2
#define QB_FIR_TYPE_BP_0K4_3K2  3

#define QB_FIR_RATE_UNK     0
#define QB_FIR_RATE_22K     1
#define QB_FIR_RATE_44K     2
#define QB_FIR_RATE_48K     3

#endif // QB_FIR_H
