/*
 *  Quadbike 2
 *  Copyright (C) 2023 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

// file new in alpha-2

#ifndef QB_SPAN_H
#define QB_SPAN_H

#include "atom2.h"
#include "span2.h"
#include "inspect.h"

void qb_span_deal_w_float_smpnum_field (qb_span_t *span, u8_t integer_to_float);

qb_err_t qb_span_insert_atom (qb_span_t *span,
                               qb_span_t *next,
                               s64_t total_input_len,
                               s32_t run_start_atom_num,
                               s64_t new_cyc_len,
                               u8_t value,
                               u8_t verbose);

void qb_span_finish (qb_span_t *span);

qb_err_t qb_mark_spans (float *goertz[2],
                        float max_powerX,
                        s64_t num_smps,
                        s32_t rate,
                        double silence_on_frac,    // for determining when signal -> silent
                        double signal_on_frac,     // for determining when silent -> signal
                        double summed_silent_frac, // for determining whether signal spans should be post-converted to silent
                        qb_span_t **spans_out,
                        s32_t *num_spans_out);
                                         

                                           
qb_err_t qb_spans_populate_tape_speeds (qb_span_t *spans,
                                        s32_t num_spans,
                                        s32_t rate,
                                        //double *src_d,
                                        float *src_f,
                                        //double *min_speed_out,
                                        //double *max_speed_out,
                                        float *min_speed_out,
                                        float *max_speed_out,
                                        u8_t display_progress,
                                        u8_t verbose,
                                        qb_inspect_t *inspect);
                                        
const char *qb_span_get_type_text (qb_span_t *s);

qb_err_t qb_span_amalgamate_spans (qb_span_t *spans, s32_t *num_spans_inout);

u8_t qb_span_has_viable_phase (qb_span_t *span);

u8_t qb_is_squawk (qb_span_t *span, qb_span_t *prev_span); // prev_span or NULL

void qb_span_set_type (qb_span_t *span, u8_t new_type);

qb_err_t qb_spans_count_and_maybe_fix_odd_runs_by_atom_insert (qb_span_t *spans,
                                                              s32_t num_spans,
                                                              s64_t total_input_len,
                                                              s32_t rate,
                                                              u8_t fix_them,
                                                              s64_t *num_data_zeroval_odd_runs_out,
                                                              s64_t *num_data_oneval_odd_runs_out,
                                                              s64_t *num_squawk_zeroval_odd_runs_out,
                                                              s64_t *num_squawk_oneval_odd_runs_out,
                                                              u8_t verbose) ;
s64_t qb_get_span_start_accurate_or_rough (qb_span_t *span);

#endif // QB_SPAN_H
