/*
 *  Quadbike 2
 *  Copyright (C) 2023 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_SYNC_WALK_H
#define QB_SYNC_WALK_H

#include "quadbike.h"
#include "process.h"
#include "feature.h"

typedef struct qb_walk_peak_valley_gap_s {
  s64_t sample_num;
  s64_t gap_len_smps;
} qb_walk_peak_valley_gap_t;

typedef struct qb_sync_walk_gaps_s {
   
   s64_t thresh; // the critical length at which a fast 1200 cycle becomes a slow 2400 cycle
   
   s64_t  max_valid_1200; // absolute maximum length of a valid 1200 cycle
   s64_t  min_valid_2400_i; // absolute minimum length of a valid 2400 cycle
   double min_valid_2400_f; // absolute minimum length of a valid 2400 cycle
   
   s64_t thresh_one_half_to_one;      // }    for
   s64_t thresh_one_to_three_halves;  // }   phase
   s64_t thresh_three_halves_to_two;  // } detection
   
   s64_t ideal_2400_i;
   double ideal_2400_f;
   
} qb_gaps_t;

qb_err_t qb_walk_identify_features (float *src_f,
                                    s64_t srclen,
                                    qb_span_t *spans,
                                    s32_t num_spans,
                                    qb_wave_feature_t **featrs_out,
                                    s64_t *num_featrs_out);
                                        
qb_err_t qb_walk_compute_gaps  (qb_gaps_t *gaps,
                                float tape_speed,
                                float rate);
                                              
qb_err_t qb_sync_walk_features_to_cycles (qb_wave_feature_t *features,
                                          s64_t num_features,
                                          s32_t sample_rate,
                                          float tape_speed,
                                          u8_t phase_ix, // alpha-2
                                          qb_atom_t **cycles_out,
                                          s32_t *num_cycles_out);
                                             
qb_err_t qb_spans_walk_interp_absent_cycs  (qb_inspect_t *inspect,
                                            qb_span_t *spans,
                                            s32_t num_spans,
                                            s32_t rate);
                                           
void qb_get_data_span_phases_by_feats  (qb_span_t *spans,
                                        s32_t num_spans,
                                        qb_wave_feature_t *feats,
                                        s64_t num_feats,
                                        float rate,
                                        u8_t dp);
                                          
qb_err_t qb_sync_walk  (qb_wave_feature_t *feats,
                        s64_t num_feats,
                        s32_t rate,
                        qb_span_t *spans,
                        s32_t num_spans);
                              

#endif // QB_SYNC_WALK_H
