/*
 *  Quadbike 2
 *  Copyright (C) 2025 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_CYCLE2_H
#define QB_CYCLE2_H

typedef struct qb_atom_s {

  // values are filled in by sync pass
  s64_t sample_num;
  
  // wasteful of memory; only used during PLL atom insertion (error correction thing)
  // to avoid rounding apocalypse; alternative would be to use a parallel array
  // just for the duration of qb_spans_count_and_maybe_fix_odd_runs_by_atom_insert(), but
  // since the cycle array grows during that function as cycles are inserted,
  // it would get messy; this is simpler:
  double tmp_smpnum_f;
  
  float pll_lock;
  
  float power0;
  float power1;
  float confidence;
  
  char value; // '0', '1' (old: 'L', 'S')
  
  u8_t synthetic; // created through interpolation
  u8_t inserted;  // created by PLL cycle insertion odd run error check
  
} qb_atom_t;

#endif // QB_ATOM2_H
