/*
 *  Quadbike 2
 *  Copyright (C) 2025 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_BUILD_H
#define QB_BUILD_H

// CONFIG
#define QB_SANITY
#define QB_FEATURE_GAP

#define QB_APP_NAME          "Quadbike"
#define QB_VERSION_U32_MAJOR 2
#define QB_VERSION_U32_MINOR 0
#define QB_VERSION_U32_SUB   3
#define QB_VERSION_DATE      "1st June 2025"

#define QB_HAVE_ZLIB

// Choose vector implementation:
//#define QB_VECTORS_GCC_CLANG
//#define QB_VECTORS_MSVC_AVX2

// platform specifics ...
#ifdef _WIN32
#define QB_WINDOWS
#endif

// Windows
#if defined QB_WINDOWS
//#define QB_WINDOWS_HEAP_DEBUG
#define _USE_MATH_DEFINES
#define QB_FILENAMES_CASE_INSENSITIVE
#ifdef QB_VECTORS_MSVC_AVX2
#define QB_ALIGNED_MALLOC
#endif // vectors

// MacOS
#elif defined QB_MACOS
#define QB_FILENAMES_CASE_INSENSITIVE

// Linux
#elif defined QB_LINUX
// on Linux, malloc doesn't automatically give you
// aligned buffers for AVX, so if we have vectors then
#ifdef QB_VECTORS_GCC_CLANG
#define QB_ALIGNED_MALLOC
#endif // QB_VECTORS_GCC_CLANG
#endif // QB_LINUX

#define QB_ERR stdout


#endif // QB_BUILD_H
