/*
 *  Quadbike 2
 *  Copyright (C) 2025 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_INSPECT_H
#define QB_INSPECT_H

#include "qb_types.h"
#include "audio2.h"
#include "atom2.h"
#include "inspect2.h"

#include <sndfile.h>
#include <stdio.h>



#define QB_INSPECT_FILE_IX_PLL_OUTPUT                   0
#define QB_INSPECT_FILE_IX_PLL_INTEGRAL                 1
#define QB_INSPECT_FILE_IX_PLL_LOCK                     2
#define QB_INSPECT_FILE_IX_PLL_QUAD_REF                 3
#define QB_INSPECT_FILE_IX_PLL_DOUBLED                  4
#define QB_INSPECT_FILE_IX_PLL_MIX                      5 // four files (0, 90, 180, 270)
#define QB_INSPECT_FILE_IX_PLL_CARRIER                  9 // four files (0, 90, 180, 270)
#define QB_INSPECT_FILE_IX_PLL_CYCLE_TIMES_PRE_INSERT   13
#define QB_INSPECT_FILE_IX_FILTERED                     14
#define QB_INSPECT_FILE_IX_WALK_UNINTERPOLATED          15
#define QB_INSPECT_FILE_IX_SPAN_TYPES                   16
#define QB_INSPECT_FILE_IX_P0                           17
#define QB_INSPECT_FILE_IX_P1                           18
#define QB_INSPECT_FILE_IX_CONFIDENCE                   19
#define QB_INSPECT_FILE_IX_CYCLE_VALUES                 20
#define QB_INSPECT_FILE_IX_CYCLE_TIMES                  21
#define QB_INSPECT_FILE_IX_SPAN_TAPESPEEDS              22
#define QB_INSPECT_FILE_IX_WALK_FEATURES                23
#define QB_INSPECT_FILE_IX_FREQ_POWER_FLIPS             24
#define QB_INSPECT_FILE_IX_WALK_FEATURES_TIMING         25

#define QB_INSPECT_FILE_IX_SPARE_FOR_DEBUGGING          26

#define QB_NUM_INSPECT_FILES                            27

#define QB_DBG_HALFBIT_VALUE_SILENCE (-30000)
#define QB_DBG_HALFBIT_VALUE_LEADER  5000
#define QB_DBG_HALFBIT_VALUE_ONE     30000
#define QB_DBG_HALFBIT_VALUE_ZERO    0


typedef struct qb_inspect_s {

  // config:
  char *dir;
  u8_t enabled;
  
  qb_inspect_file_t files[QB_NUM_INSPECT_FILES];
  
  u8_t allow_overwrite;
  
} qb_inspect_t;


qb_err_t qb_inspect_init (qb_inspect_t *i, s32_t rate);

#include "span2.h"

qb_err_t qb_inspect_append_bitsamples (qb_span_t *span0,
                                       qb_span_t *span1,
                                       s64_t *prev_final_smpnum_inout,
                                       s32_t span0_ix,
                                       //qb_inspect_t *inspect,
                                       qb_inspect_file_t *f);
                                 
qb_err_t qb_inspect_append_halfbit_values (qb_span_t *span0,
                                           qb_span_t *span1,
                                           s32_t span0_ix,
                                           //qb_inspect_t *inspect,
                                           qb_inspect_file_t *f,
                                           s16_t *previous_atom_value_inout,
                                           s64_t *prev_smpnum_inout);
                               
qb_err_t qb_inspect_open_if_needed (qb_inspect_file_t *ifile);
                    
qb_err_t qb_inspect_append_span_goertzel_power (float *goertzel[2],
                                                s64_t srclen_smps,
                                                float max_powerX,
                                                float max_confidence,
                                                qb_inspect_t *inspect);
                                               
qb_err_t qb_inspect_append_s16_buf (qb_inspect_file_t *ifile,
                                    s16_t *buf,
                                    s64_t len);
                                    
qb_err_t qb_inspect_build_and_stat_path  (char *dir,
                                          const char *fn,
                                          char **path_out);

void qb_close_inspect_file (qb_inspect_file_t *inspect_file);

#include "feature.h"

qb_err_t qb_inspect_write_features (qb_inspect_t *inspect,
                                    qb_wave_feature_t *feats,
                                    s64_t num_feats,
                                    s64_t input_len);

#ifdef QB_EXPERIMENTAL_INSPECT_WRITE_FEATURES_TIMING
qb_err_t qb_inspect_write_features_timing  (qb_inspect_t *inspect,
                                            qb_wave_feature_t *feats,
                                            s64_t num_feats,
                                            s64_t input_len,
                                            s32_t rate);
#endif // QB_EXPERIMENTAL_INSPECT_WRITE_FEATURES_TIMING

qb_err_t qb_inspect_append_span_types (qb_span_t *spans,
                                       s64_t full_input_len,
                                       s32_t num_spans,
                                       //s32_t rate,
                                       qb_inspect_t *inspect);
                                       
extern const char *qb_inspect_filenames[QB_NUM_INSPECT_FILES][2];

#endif // QB_INSPECT_H
