/*
 *  Quadbike 2
 *  Copyright (C) 2025 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_QB_TYPES_H
#define QB_QB_TYPES_H

#include "build.h"
#include <stdint.h>

#ifdef QB_WINDOWS
#define QB_FUNC_M                                     __FUNCTION__
#define QB_SNPRINTF(BUF,BUFSIZE,MAXCHARS,FMTSTG,...)  _snprintf_s((BUF),(BUFSIZE),(MAXCHARS),(FMTSTG),__VA_ARGS__)
#define QB_SCPRINTF(FMTSTG,...)                       _scprintf((FMTSTG),__VA_ARGS__)
#else
#define QB_FUNC_M                                     __func__
#define QB_SNPRINTF(BUF,BUFSIZE,MAXCHARS,FMTSTG...)   snprintf((BUF),(BUFSIZE),FMTSTG)
#define QB_SCPRINTF(FMTSTG...)                        snprintf(&qb_scprintf_dummy, 0, FMTSTG)
#endif /* end ndef QB_WINDOWS */

typedef int qb_err_t;


typedef unsigned char      u8_t;
typedef signed char        s8_t;
typedef unsigned short     u16_t;
typedef signed short       s16_t;
typedef unsigned int       u32_t;
typedef signed int         s32_t;
//typedef unsigned long long u64_t;
//typedef long long          s64_t;

/*
typedef uint8_t  u8_t;
typedef int8_t   s8_t;
typedef uint16_t u16_t;
typedef int16_t  s16_t;
typedef uint32_t u32_t;
typedef int32_t  s32_t;
typedef uint64_t u64_t;
typedef int64_t  s64_t;
*/

#ifdef QB_WINDOWS
#include "BaseTsd.h"
#endif

#ifdef QB_VECTORS_MSVC_AVX2
#include <immintrin.h>
#endif

#ifdef QB_WINDOWS
typedef UINT64             u64_t;
typedef INT64              s64_t;
#else
typedef unsigned long long u64_t;
typedef long long          s64_t;
//typedef uint64_t u64_t;
//typedef int64_t  s64_t;
#endif

#define QB_PI ((float) M_PI)

#endif // QB_QB_TYPES_H
