/*
 *  Quadbike 2
 *  Copyright (C) 2025 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/
#ifndef QB_SPAN2_H
#define QB_SPAN2_H


#define QB_SPAN_TYPE_INVALID 0
#define QB_SPAN_TYPE_SILENT  1
#define QB_SPAN_TYPE_LEADER  2
#define QB_SPAN_TYPE_DATA    3

#include "atom2.h"

typedef struct qb_span_s {
  s64_t start;
  s64_t len;
  u8_t type;
  float speed;
  qb_atom_t *atoms;
  s32_t num_atoms;
  s8_t detected_input_phase_ix;    // -1 if not set
  u8_t reverses_output_polarity;
  u8_t need_to_invert;
  double pll_lock_quality;         // lock, averaged across the span
  u8_t transient_pll_lock_dropout; // set if there is a *transient* lock dropout
  s64_t first_feature_ix;
} qb_span_t;

#endif // QB_SPAN2_H
