/*
 *  Quadbike 2
 *  Copyright (C) 2026 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef QB_CYCLE_H
#define QB_CYCLE_H

#include "quadbike.h"
#include "atom2.h"
#include "source.h"
#include "span.h"

#define QB_CYCLE_SIGNAL_QUALITY_UNK   0
#define QB_CYCLE_SIGNAL_QUALITY_GOOD  1
#define QB_CYCLE_SIGNAL_QUALITY_BAD   2

#define QB_MAX_ATOMS     800000000

void qb_init_atom (qb_atom_t *c);

qb_err_t qb_span_measure_atom_powers (float *goertz[2],
                                      float goertz_hf_test_multiplier, // 2.0.4, for scan only (else 1.0)
#ifdef QB_SANITY
                                       s64_t goertzel_len_smps,
#endif
                                       // gets updated: timing in, power out:
                                       qb_atom_t *atoms,
                                       s32_t num_atoms,
                                       u8_t update_atoms, // set to 1 once optimum shift established, to update atom timings
                                       s8_t shift_smps,
                                       float *summed_confidence_out);
                             
qb_err_t qb_take_power_samples (
#ifdef QB_SANITY
                                s64_t srclen_smps,
#endif
                                qb_span_t *spans_inout,
                                s32_t num_spans,
                                u8_t suppress_output,
                                //u8_t do_shift_search,
                                u8_t use_forced_shift,
                                s8_t forced_shift,
                                float *goertz[2],
                                float goertz_hf_test_multiplier);

qb_err_t qb_atoms_assign_values (qb_source_t *src, u8_t display_progress);

qb_err_t qb_append_atom  (qb_atom_t *si,
                           qb_atom_t **atoms_inout,
                           s32_t *alloc,
                           s32_t *fill );

qb_err_t qb_fill_missing_atoms_on_leader_spans_and_adjust_limits (qb_span_t *spans,
                                                                 s32_t num_spans,
                                                                 s32_t rate,
                                                                 s64_t total_input_smps);
                                                        
qb_err_t qb_create_two_atoms_on_silent_spans (qb_span_t *spans, s32_t num_spans, u8_t verbose);

u8_t qb_atom_get_value_bool (qb_atom_t *atom);

#endif // QB_ATOM_H
