/*
 *  Quadbike 2
 *  Copyright (C) 2026 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/
#ifndef QB_SYNC_H
#define QB_SYNC_H

#include "quadbike.h"
#include "atom2.h"
#include "span.h"
#include "pll.h"
#include "sync_walk.h"

qb_err_t qb_get_sync_for_data_spans  (u8_t sync_method,
                                      s64_t srclen_smps,
                                      s32_t rate,
                                      qb_span_t *spans,
                                      s32_t num_spans,
                                      qb_pll_carrier_t pll_carriers[4], // for PLL only
                                      qb_inspect_t *inspect,
                                      u8_t display_progress,
                                      u8_t silent,
                                      float *goertz[2],
                                      float hf_goertz_test_multiplier, // 2.0.4 -- hf scan mode only (else 1.0)
                                      float max_powerX,
                                      qb_wave_feature_t *feats,         // for walk mode only
                                      s64_t num_feats,                  // for walk mode only
                                      u8_t verbose,
                                      u8_t freq_allow_odd_runs);

#endif // QB_SYNC_H
