/*
 *  Quadbike 2
 *  Copyright (C) 2025 'Diminished'

 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include "bp_0k4_3k2_22k.h"

/*

FIR filter designed with
 http://t-filter.appspot.com

sampling frequency: 22000 Hz

* 0 Hz - 100 Hz
  gain = 0
  desired attenuation = -40 dB
  actual attenuation = -40.05922555219949 dB

* 400 Hz - 3200 Hz
  gain = 1
  desired ripple = 5 dB
  actual ripple = 4.146485978988547 dB

* 3600 Hz - 11000 Hz
  gain = 0
  desired attenuation = -40 dB
  actual attenuation = -40.05922555219949 dB

*/

const double qb_fir_taps_bp_0k4_3k2_22k[QB_FIR_TAPS_BP_0K4_3K2_22K] = {
  0.0140447380081868,
  0.023931389628842323,
  0.03175085742710887,
  0.0296036889489605,
  0.01596308219324319,
  -0.0038380913283811435,
  -0.02001289041895641,
  -0.024421935334877517,
  -0.016290587899491105,
  -0.0031120735830256433,
  0.004458064694113445,
  0.0003777067772305666,
  -0.012204339734527439,
  -0.023363071055192617,
  -0.02426673073107876,
  -0.014471343922079218,
  -0.002663112802415523,
  0.0002120012357953013,
  -0.009788208791402207,
  -0.025680505126166122,
  -0.03467085805741605,
  -0.02878509597085063,
  -0.012412642380925333,
  0.00020454309376843975,
  -0.003691404422239965,
  -0.023800661679506285,
  -0.04515300554881786,
  -0.04909237705063899,
  -0.02929164844502588,
  0.0002991103410407341,
  0.01371221102040019,
  -0.00672875812645684,
  -0.05273011740438293,
  -0.08983656731820266,
  -0.07785145186369344,
  0.00040756504322087483,
  0.12216833523553247,
  0.2331284524256065,
  0.2778594198435762,
  0.2331284524256065,
  0.12216833523553247,
  0.00040756504322087483,
  -0.07785145186369344,
  -0.08983656731820266,
  -0.05273011740438293,
  -0.00672875812645684,
  0.01371221102040019,
  0.0002991103410407341,
  -0.02929164844502588,
  -0.04909237705063899,
  -0.04515300554881786,
  -0.023800661679506285,
  -0.003691404422239965,
  0.00020454309376843975,
  -0.012412642380925333,
  -0.02878509597085063,
  -0.03467085805741605,
  -0.025680505126166122,
  -0.009788208791402207,
  0.0002120012357953013,
  -0.002663112802415523,
  -0.014471343922079218,
  -0.02426673073107876,
  -0.023363071055192617,
  -0.012204339734527439,
  0.0003777067772305666,
  0.004458064694113445,
  -0.0031120735830256433,
  -0.016290587899491105,
  -0.024421935334877517,
  -0.02001289041895641,
  -0.0038380913283811435,
  0.01596308219324319,
  0.0296036889489605,
  0.03175085742710887,
  0.023931389628842323,
  0.0140447380081868
};
